﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Asteroid
  {
  enum ObjectType { NotDefined, Starship, Shot, Asteroid, Ufo, CurTarget };

  /// <summary>
  /// Informationen zum aktuellen Kurs
  /// </summary>
  /// ****************************************************************************************************
  /// * Datum: 20.04.2008 13:01
  /// * Computer: ATHLON3500VISTA
  /// * Benutzer: thomas
  /// *
  /// * Beschreibung: Informationen zum aktuellen Kurs
  /// ****************************************************************************************************
  class Course
    {
    /// <summary>
    /// Kontruktor
    /// </summary>
    /// ****************************************************************************************************
    /// * Datum: 20.04.2008 13:20
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Kontruktor 
    /// ****************************************************************************************************
    public Course()
      {
      for (int i = 0; i < Pos.Length; i++)
        Pos[i] = new Position();
      }

    private Position[] m_arrPos = new Position[3];
    /// <summary>
    /// Setzt oder gibt die nächsten drei Positionen zurück.
    /// </summary>
    /// <value>The pos.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.06.2008 14:34
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Setzt oder gibt die nächsten drei Positionen zurück.
    /// ****************************************************************************************************
    public Position[] Pos
      {
      get
        {
        return m_arrPos;
        }
      set
        {
        m_arrPos = value;
        }
      }

    private int m_iVX = 0;
    /// <summary>
    /// Beschreibung: Setzt oder gibt die Geschwindigkeit auf der X-Achse zurück.
    /// </summary>
    /// <value>The VX.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.06.2008 14:38
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Setzt oder gibt die Geschwindigkeit auf der X-Achse zurück.
    /// ****************************************************************************************************
    public int VX
      {
      get
        {
        return m_iVX;
        }
      set
        {
        m_iVX = value;
        }
      }

    private int m_iVY = 0;
    /// <summary>
    /// Beschreibung: Setzt oder gibt die Geschwindigkeit auf der Y-Achse zurück.
    /// </summary>
    /// <value>The VY.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.06.2008 14:38
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Setzt oder gibt die Geschwindigkeit auf der Y-Achse zurück.
    /// ****************************************************************************************************

    public int VY
      {
      get
        {
        return m_iVY;
        }
      set
        {
        m_iVY = value;
        }
      }
    }

  /// <summary>
  /// Information zur aktuellen Geschwindigkeit
  /// </summary>
  /// ****************************************************************************************************
  /// * Datum: 20.04.2008 13:01
  /// * Computer: ATHLON3500VISTA
  /// * Benutzer: thomas
  /// *
  /// * Beschreibung: Information zur aktuellen Geschwindigkeit 
  /// ****************************************************************************************************
  class Position
    {
    private int m_iX = 0;
    /// <summary>
    /// Setzt oder gibt die X-Position.
    /// </summary>
    /// <value>The X.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.06.2008 14:42
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Setzt oder gibt die X-Position. 
    /// ****************************************************************************************************
    public int X
      {
      get
        {
        return m_iX;
        }
      set
        {
        m_iX = value;
        }
      }

    private int m_iY = 0;
    /// <summary>
    /// Setzt oder gibt die Y-Position.
    /// </summary>
    /// <value>The Y.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.06.2008 14:42
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Setzt oder gibt die Y-Position. 
    /// ****************************************************************************************************
    public int Y
      {
      get
        {
        return m_iY;
        }
      set
        {
        m_iY = value;
        }
      }
    }

  /// <summary>
  /// Bildschirmobjekt von Asteroid
  /// </summary>
  /// ****************************************************************************************************
  /// * Datum: 14.06.2008 14:20
  /// * Computer: ATHLON3500VISTA
  /// * Benutzer: thomas
  /// *
  /// * Beschreibung: Bildschirmobjekt von Asteroid 
  /// ****************************************************************************************************
  class ScreenObject
    {
    protected int m_iScaleFaktor = 0;
    protected int m_iUfoSize = 0;

    private byte m_AngleByte = 0;
    /// <summary>
    /// Gets the angle byte.
    /// </summary>
    /// <value>The angle byte.</value>
    /// ****************************************************************************************************
    /// * Datum: 27.06.2008 21:48
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public byte AngleByte
      {
      get
        {
        return m_AngleByte;
        }
      set
        {
        m_AngleByte = value;
        }
      }

    private int m_iminDistance = 0xffff;
    /// <summary>
    /// Gets the distance.
    /// </summary>
    /// <value>The distance.</value>
    /// ****************************************************************************************************
    /// * Datum: 27.06.2008 21:46
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public int Distance
      {
      get
        {
        return m_iminDistance;
        }
      }

    protected ObjectType m_ObjectType = ObjectType.NotDefined;
    /// <summary>
    /// Gibt den Objekttyp zurück.
    /// </summary>
    /// <value>The type of the object.</value>
    /// ****************************************************************************************************
    /// * Datum: 19.05.2008 18:03
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Gibt den Objekttyp zurück. 
    /// ****************************************************************************************************
    public ObjectType ObjectType
      {
      get
        {
        return m_ObjectType;
        }
      }


    protected bool m_bKnown = false;
    /// <summary>
    /// Zeigt an, ob das Objekt bekannt ist.
    /// </summary>
    /// <value><c>true</c> if this instance is known; otherwise, <c>false</c>.</value>
    /// ****************************************************************************************************
    /// * Datum: 20.04.2008 12:59
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Zeigt an, ob das Objekt bekannt ist. 
    /// ****************************************************************************************************
    public bool IsKnown
      {
      get
        {
        return m_bKnown;
        }
      }

    protected bool m_bCurrentTarget = false;
    /// <summary>
    /// Zeigt an, ob da Objekt das aktuelle Ziel ist.
    /// </summary>
    /// <value>
    /// 	<c>true</c> if this instance is current target; otherwise, <c>false</c>.
    /// </value>
    /// ****************************************************************************************************
    /// * Datum: 19.04.2008 21:21
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Zeigt an, ob da Objekt das aktuelle Ziel ist. 
    /// ****************************************************************************************************
    public bool IsCurrentTarget
      {
      get
        {
        return m_bCurrentTarget;
        }
      set
        {
        m_bCurrentTarget = value;
        }
      }

    protected Position m_CurrentPos = new Position();
    /// <summary>
    /// Liefert die aktuelle Position des Objektes.
    /// </summary>
    /// <value>The current pos.</value>
    /// ****************************************************************************************************
    /// * Datum: 19.04.2008 22:26
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Liefert die aktuelle Position des Objektes. 
    /// ****************************************************************************************************
    public Position CurrentPos
      {
      get
        {
        return m_CurrentPos;
        }
      set
        {
        m_CurrentPos = value;
        }
      }

    protected int m_iCountShots = 0;
    /// <summary>
    /// Anzahl der Schüsse auf ein Objekt.
    /// </summary>
    /// <value>The count shots.</value>
    /// ****************************************************************************************************
    /// * Datum: 13.05.2008 21:27
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Anzahl der Schüsse auf ein Objekt.
    /// ****************************************************************************************************
    public int CountShots
      {
      get
        {
        return m_iCountShots;
        }
      set
        {
        m_iCountShots = value;
        }
      }

    protected Position m_CurrentShotPos = new Position();
    /// <summary>
    /// Liefert die aktuelle Position auf die geschossen werden soll.
    /// </summary>
    /// <value>The current shot pos.</value>
    /// ****************************************************************************************************
    /// * Datum: 13.05.2008 20:44
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Liefert die aktuelle Position auf die geschossen werden soll.
    /// ****************************************************************************************************
    public Position CurrentShotPos
      {
      get
        {
        return m_CurrentShotPos;
        }
      set
        {
        m_CurrentShotPos = value;
        }
      }

    protected Course m_Cource = new Course();
    /// <summary>
    /// Zeigt den aktuellen Kurs an.
    /// </summary>
    /// <value>The current course.</value>
    /// ****************************************************************************************************
    /// * Datum: 19.04.2008 22:26
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Zeigt den aktuellen Kurs an.
    /// ****************************************************************************************************
    public Course CurrentCourse
      {
      get
        {
        return m_Cource;
        }
      set
        {
        m_Cource = value;
        }
      }

    protected bool m_bFrendly = false;
    /// <summary>
    /// Prüft ob ein Objekt feindlich ist.
    /// </summary>
    /// <value>
    /// 	<c>true</c> if this instance is frendly; otherwise, <c>false</c>.
    /// </value>
    /// ****************************************************************************************************
    /// * Datum: 19.04.2008 17:59
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Prüft ob ein Objekt feindlich ist.
    /// ****************************************************************************************************
    public bool IsFrendly
      {
      get
        {
        return m_bFrendly;
        }
      set
        {
        m_bFrendly = value;
        }
      }

    /// <summary>
    /// Berechnet die Zielposition
    /// </summary>
    /// <param name="MyShip">My ship.</param>
    /// <param name="iLatenz">The i latenz.</param>
    /// <param name="AngleByte">The angle byte.</param>
    /// <returns></returns>
    /// ****************************************************************************************************
    /// * Datum: 12.05.2008 12:38
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Berechnet die Zielposition
    /// ****************************************************************************************************
    public int CalculateShotPosition(ref StarShip MyShip, ref int iLatenz, ref byte AngleByte, ref AngleInformation[] AngleTable)
      {
      int iDistance = 0;
      double dCountFrameDistance1 = 0;
      int iDx = m_CurrentPos.X - MyShip.CurrentPos.X;
      int iDy = m_CurrentPos.Y - MyShip.CurrentPos.Y;

      Normalize(ref iDx, ref iDy);

      iDistance = iDx * iDx + iDy * iDy;
      dCountFrameDistance1 = Math.Sqrt(iDistance) / 8.0;

      switch (m_iScaleFaktor)
        {
        // Abstand um den ungefähren Radius des Asteroiden korrigieren
        case 0:  // großer Asteroid
          iDistance -= 40 * 40;
          break;
        case 15: // mittlerer Asteroid
          iDistance -= 20 * 20;
          break;
        case 14: // kleiner Asteroid
          iDistance -= 8 * 8;
          break;
        }

      switch (m_iUfoSize)
        {
        // Abstand um den ungefähren Radius des UFOs korrigieren
        case 15: // großes UFO
          iDistance -= 20 * 12;
          break;
        case 14: // kleines UFO
          iDistance -= 10 * 6;
          break;
        }

      // Wenn der Asteroid bekannt ist
      if (m_bKnown)
        {
        // Zielpunkt berechnen

        iDx = m_CurrentPos.X - MyShip.CurrentPos.X;
        iDy = m_CurrentPos.Y - MyShip.CurrentPos.Y;

        Normalize(ref iDx, ref iDy);

        double VTarget = Math.Sqrt(m_Cource.VX * m_Cource.VX + m_Cource.VY * m_Cource.VY);
        int iDx2 = m_Cource.VX;
        int iDy2 = m_Cource.VY;
        Normalize(ref iDx2, ref iDy2);
        double dx = VTarget / 8.0 * Math.Sin(Math.Atan2(iDy2, iDx2) - Math.Atan2(iDy, iDx));

        if (Math.Abs(dx) >= 1)
          dx = dx - Math.Truncate(dx);

        //Console.WriteLine("*********************************************************************");
        //Console.WriteLine("Targetdata:");
        //Console.WriteLine("x: {0}, y: {1}, SpeedX: {2}, SpeedY: {3}", iDx, iDy, m_Cource.SpeedX, m_Cource.SpeedY);
        //Console.WriteLine("V: {0:f4}, Course: {1:f4}, Viewangle: {2:f4}", VTarget, Math.Atan2(iDy2, iDx2) * 180 / Math.PI, Math.Atan2(iDy, iDx) * 180 / Math.PI);
        //Console.WriteLine();

        double dTargetAngle = Math.Asin(dx) + Math.Atan2(iDy, iDx);

        iDx = (int)Math.Round(Math.Cos(dTargetAngle) * 1536);
        iDy = (int)Math.Round(Math.Sin(dTargetAngle) * 1536);

        //Console.WriteLine("Solution:");
        //Console.WriteLine("Angle: {0:f4}, X: {1}, Y: {2}", Alpha * 180 / Math.PI, iDx, iDy);
        //Console.WriteLine("*********************************************************************");


        // Ermittelten Zielpunkt mit Winkelbyte synchronisieren

        byte Buffer = (byte)(AngleByte - 43);
        byte Buffer2 = 0;
        double dBuffer = 1e99;
        double dBuffer2 = 1e99;

        // Richtiges Winkelbyte in der aktuellen Umdrehnung suchen
        for (int i = AngleByte - 43; i < AngleByte + 43; i++)
          {
          if (iDx >= 0 && iDy >= 0 && AngleTable[Buffer].InternX >= 0 && AngleTable[Buffer].InternY >= 0)
            {
            dBuffer = Math.Abs(Math.Atan2(AngleTable[Buffer].InternY, AngleTable[Buffer].InternX) - Math.Atan2(iDy, iDx));
            }
          else
            {
            if (iDx < 0 && iDy >= 0 && AngleTable[Buffer].InternX < 0 && AngleTable[Buffer].InternY >= 0)
              {
              dBuffer = Math.Abs(Math.Atan2(AngleTable[Buffer].InternY, AngleTable[Buffer].InternX) - Math.Atan2(iDy, iDx));
              }
            else
              {
              if (iDx < 0 && iDy < 0 && AngleTable[Buffer].InternX < 0 && AngleTable[Buffer].InternY < 0)
                {
                dBuffer = Math.Abs(Math.Atan2(AngleTable[Buffer].InternY, AngleTable[Buffer].InternX) - Math.Atan2(iDy, iDx));
                }
              else
                {
                if (iDx >= 0 && iDy < 0 && AngleTable[Buffer].InternX >= 0 && AngleTable[Buffer].InternY < 0)
                  {
                  dBuffer = Math.Abs(Math.Atan2(AngleTable[Buffer].InternY, AngleTable[Buffer].InternX) - Math.Atan2(iDy, iDx));
                  }
                }
              }
            }

          if (dBuffer < dBuffer2)
            {
            Buffer2 = Buffer;
            dBuffer2 = dBuffer;
            }

          Buffer++;
          }

        iDx = AngleTable[Buffer2].InternX;
        iDy = AngleTable[Buffer2].InternY;
        m_AngleByte = Buffer2;

        m_CurrentShotPos.X = iDx;
        m_CurrentShotPos.Y = iDy;
        }

      m_iminDistance = iDistance;
      return iDistance;
      }

    /// <summary>
    /// Normalisieren der Koordinaten.
    /// </summary>
    /// <param name="iDx">The i dx.</param>
    /// <param name="iDy">The i dy.</param>
    /// ****************************************************************************************************
    /// * Datum: 21.05.2008 21:58
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Normalisieren der Koordinaten. 
    /// ****************************************************************************************************
    private static void Normalize(ref int iDx, ref int iDy)
      {
      // dx normalisieren auf -512 ... 511
      while (iDx < -512)
        iDx += 1024;
      while (iDx > 511)
        iDx -= 1024;

      // dy normalisieren auf -384 ... 383

      while (iDy < -384)
        iDy += 768;
      while (iDy > 383)
        iDy -= 768;
      }


    /// <summary>
    /// Berechnet den Kurs des Objektes.
    /// </summary>
    /// <param name="BackwardPos">The backward pos.</param>
    /// ****************************************************************************************************
    /// * Datum: 19.04.2008 22:24
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Berechnet den Kurs des Objektes.
    /// ****************************************************************************************************
    public void CalculateCourse(ref Position BackwardPos)
      {
      m_Cource.VX = m_CurrentPos.X - BackwardPos.X;
      m_Cource.VY = m_CurrentPos.Y - BackwardPos.Y;

      //Console.WriteLine("{0}   {1}", m_CurrentPos.X, BackwardPos.X);
      m_bKnown = false;

      switch (m_ObjectType)
        {
        case ObjectType.CurTarget:
        case ObjectType.Ufo:
          m_bKnown = true;
          break;
        case ObjectType.Asteroid:
          if (m_Cource.VX <= 6 && m_Cource.VY <= 6)
            m_bKnown = true;
          else
            m_bKnown = false;
          break;

        case ObjectType.NotDefined:
          m_bKnown = false;
          break;

        case ObjectType.Shot:
          if (m_Cource.VX <= 11 && m_Cource.VY <= 11)
            m_bKnown = true;
          else
            m_bKnown = false;
          break;

        case ObjectType.Starship:
          m_bKnown = true;
          break;
        }

      if (m_bKnown && m_ObjectType == ObjectType.Shot)
        {
        for (int i = 0; i < m_Cource.Pos.Length; i++)
          {
          m_Cource.Pos[i].X = m_CurrentPos.X + ((i + 1) * m_Cource.VX);
          m_Cource.Pos[i].Y = m_CurrentPos.Y + ((i + 1) * m_Cource.VY);
          }
        }
      }
    }
  }
